# to autoload this file
proc m2CompErr.tcl {} {}

#================================================================================
#  Compiler error display in M2 working files  #
#================================================================================

namespace eval M2 {}

# force loading of mode or variables won't be defined
M2load

#================================================================================
proc getCurWord {} {
    set pos [getPos]
    backwardWord
    set bPos [getPos]
    if {[pos::compare $bPos == [pos::math [minPos] + 1]]} {
	set text " "
	regexp "\[A-Za-z\]" [lookAt [minPos]] text
	if {$text != " "} {
	    set bPos [minPos]
	}
    }
    
    forwardWord
    set fPos [getPos]
    goto $pos
    return [getText $bPos $fPos]
}

#================================================================================
proc selectCurWord {} {
    set pos [getPos]
    set char [lookAt [pos::math $pos - 1]]
    if {[regexp "\[A-Za-z\]" $char] == 0} {
	set bPos [pos::math $pos + 1]
    } else {
	backwardWord
	set bPos [getPos]
	if {[pos::compare $bPos == [pos::math [minPos] + 1]]} {
	    set text " "
	    regexp "\[A-Za-z\]" [lookAt [minPos]] text
	    if {$text != " "} {
		set bPos [minPos]
	    }
	}
	
	forwardWord
    }
    select $bPos [getPos]
}

#================================================================================
proc fileExt {} {
	set fileName [lindex [winNames -f] 0]
	if {[string last "." $fileName] == -1} {
		return " "
	}
	set fileName [split $fileName .]
	return [lindex $fileName [expr "[llength $fileName]-1"]]
}

	
#================================================================================
proc removeM2ErrMarks {fileName} {
	global m2ErrRing
	while 1 {
		set ind [lsearch $m2ErrRing "*$fileName*"]
		if {$ind == "-1"} {
			return
		}
		set m2ErrRing [lreplace $m2ErrRing $ind $ind]
	}
}

#================================================================================
proc removeAllM2ErrMarks {} {
	global m2ErrRing
	while {[llength $m2ErrRing] != 0} {
		removeTMark [lindex [lindex $m2ErrRing 0] 1]
		set m2ErrRing [lreplace $m2ErrRing 0 0]
	}
}

#================================================================================
proc actM2ErrMsg {} {
	global m2ErrRing
	global errList
	beep
	if {[llength $m2ErrRing] == "0"} {
		message "No M2 compiler errors"
		beep
		return
	}
	set num [lindex [lindex $m2ErrRing 0] 2]
	regexp "$num\[ \]+(\[^\n\]*)" $errList dummyStr errMsg
	set errMsg [string range $errMsg 0 100]
	message $errMsg
}


#================================================================================
proc findNextError {} {
	global m2ErrRing
	global errList
	global posBeforeJumpOutOfLn
	global selEndBeforeJumpOutOfLn
	# Initialize posBeforeJumpOutOfLn and selEndBeforeJumpOutOfLn in a file specific way
	set posBeforeJumpOutOfLn [getPos]
	set selEndBeforeJumpOutOfLn [selEnd]
	set fileName [lindex [winNames -f] 0]
	if {[llength $m2ErrRing] == "0"} {
		beep
		message "No more M2 compiler errors"
		return
	}
	set first [lindex $m2ErrRing 0]
	set m2ErrRing [lreplace $m2ErrRing 0 0]
	set m2ErrRing [lappend m2ErrRing $first]
	gotoTMark [lindex [lindex $m2ErrRing 0] 1]
	if {$fileName != [lindex [winNames -f] 0]} {
		centerRedraw
	}
	selectCurWord
	actM2ErrMsg
}



#================================================================================
set loadM2ErrorMsg ""

proc openM2WorkFiles {} {
    global m2ErrRing
    global errList
    global M2ErrFile
    global M2errDOKFile
    global M2ShellHome
    global loadM2ErrorMsg
    set awindowOpen [winNames -f]
    if {$awindowOpen != ""} then {
	removeAllM2ErrMarks
    }
    set m2ErrRing ""
    if {![info exists M2errDOKFile]} then {
#alertnote "M2errDOKFile does not exist"
	set loadM2ErrorMsg "Can't open M2 work files! Check MacMETH or RAMSES installation and/or reconfigure launching from within M2 mode"
    } else {
#alertnote "${M2errDOKFile}"
	if {![file exists ${M2errDOKFile}]} then {
	    set loadM2ErrorMsg "Can't open M2 work files. Check MacMETH or RAMSES installation and/or reconfigure launching from within M2 mode"
#alertnote "M2errDOKFile missing"
	} else {
	    set loadM2ErrorMsg "Can't open/read $M2errDOKFile, please enter at least once M2 mode or reconfigure launching"
#alertnote "M2errDOKFile found"
	}
    }
    set msgFile [open "$M2errDOKFile"]
    set errList [read $msgFile]
#alertnote "$msgFile found"
    # discard begin up to "Syntax errors" to avoid confounding of years with error numbers 
    regexp {(.+)(Syntax .+)} $errList all headers errList
    close $msgFile
    set loadM2ErrorMsg "Can't open/read $M2ErrFile, please enter at least once M2 mode or reconfigure launching"
#alertnote "M2ErrFile defined"
    set errFile [open "$M2ErrFile"]
    if  {[gets $errFile lineStr] < 1} {
	beep
	message "No M2 working files to open"
	close $errFile
	return
    }
    set numErrs 0
#alertnote "numErrs inited"
    set i 1
    while {$lineStr == "NEW"} {
	if  {[gets $errFile lineStr] < 1} {
	    break
	}
	# set fileToEditName [file tail $lineStr]
	set fileToEditName $lineStr
	set loadM2ErrorMsg "Can't open $fileToEditName"
	set ind [lsearch [winNames -f] $lineStr]
	if {$ind == -1} {
	    if {[file exists $lineStr]} {
		# it is an absolute path and file name
		edit -c -w "$lineStr"
	    } elseif {[regexp {^[:]+} $lineStr]} {
		# it is a relative path and file name
		# If you expect crash of this proc in subsequent edit command, close errFile
		if {![file exists "$M2ShellHome$lineStr"]} {close $errFile}
		edit -c -w "$M2ShellHome$lineStr"
	    } else {
		# it is not a relative path, and not an absolute path, but just a file name
		# If you expect crash of this proc in subsequent edit command, close errFile
		if {![file exists "$M2ShellHome:$lineStr"]} {close $errFile}
		edit -c -w "$M2ShellHome:$lineStr"
	    }
	} else {
	    bringToFront [lindex [winNames] $ind]
	}
	set loadM2ErrorMsg "Can't open/read $M2ErrFile, please enter at least once M2 mode or reconfigure launching"
	if  {[gets $errFile lineStr] < 1} {
	    break
	}
	set fileName [lindex [winNames -f] 0]
	while {($lineStr != "NEW") && ($lineStr != "END")} {
	    scan $lineStr "%d %d" pos errNum
	    if  {[gets $errFile lineStr] < 1} {
		break
	    }
	    goto $pos
	    createTMark "errMark$i" $pos
	    set m2ErrRing [lappend m2ErrRing [list $fileName errMark$i $errNum]]
	    set i [expr $i+1]
	    set numErrs [expr $numErrs+1]
	}
    }
    if {$numErrs < 1} {
	beep
	message "No M2 compiler errors found"
	close $errFile
	return
    }
    close $errFile
    gotoTMark errMark1
    set pos [getPos]
    centerRedraw
    selectCurWord
    actM2ErrMsg
}



proc M2::openWorkFiles {} {
    global loadM2ErrorMsg
    if {[catch openM2WorkFiles]} {
	beep
	if {[info exists loadM2ErrorMsg]} then {
	    alertnote "Error: $loadM2ErrorMsg.  Encountered while attempting to open the M2 work file(s)."
	} else {
	    alertnote "Error in M2 mode: Sorry, unexpected error encountered while attempting to open the M2 work file(s). Probably bad M2 mode installation."
	}
    }
}



# for M2 menu only
proc openWorkFiles {} {
    M2::openWorkFiles
}


# Reporting that end of this script has been reached
message "m2CompErr.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
    alertnote "m2CompErr.tcl for Programing in Modula-2 loaded"
}
